/******************** SDbyIrDA.h ***********************/
/*-----------------------------------------------------*/


/********** DEFINES SCI USED PORT, BAUDRATE AND COMPARATOR REFERENCE *************/
#define USED_PORT       1       /* Selects the port used for communication */
#define BAUDRATE        38400   /* Use 9600, 19200 or 38400 in this application */
#define REFERENCE_LEVEL 20      /* Reference voltage used by the comparator */


/******** COMANDS USED IN THE APPLICATION *************/
enum
{
 IrDA_INACTIVE,
 IrDA_SD_TO_SCI, 
 IrDA_SCI_TO_SD,
 SD_INACTIVE,
 SD_FILE_WRITING,   
 SD_FILE_READING   
};


/********************** GENERAL VARIABLES USED *****************/
extern UINT8  u8sd_status;       /* Variable to indicate SD status */
extern UINT8  u8sd_command;      /* Variable to indicate commands for SD */
extern UINT8  u8irda_status;     /* Variable to indicate commands for IrDA */
extern UINT8  u8buffer[512];     /* Array to store information of the SD */
extern UINT16 u16buffer_index;   /* Variable to indicate position of buffer */
extern UINT16 u16file_counter;   /* Variable to indicate remaining bytes of a file */


/********************** FUNCTION PROTOTYPES *****************/
void vfnMGC_init(void);	  /* Initializes clock using external crystal */
void vfnWelcome(void);	  /* Send a Welcome message */
void vfnSysHalt(void);	  /* Halts the system */
void vfnSDwelcome(void);	/* Check if SD is present and if the file exists */
void vfnReadFile(void);	  /* Reads the file stored in the SD card */
void vfnWriteFile(void);	/* Writes the file stored in the SD card */

